# ChipOS Claude Commands for Voyager SDK

This directory contains Claude Code slash commands optimized for **Axelera Metis AI hardware** and **Voyager SDK** development with ChipOS MCP integration.

## Important: Axelera Hardware Focus

**All commands in this directory are specifically designed for:**
- **Axelera Metis AI Processing Units (APUs)** - M.2 and PCIe form factors
- **Voyager SDK** - Axelera's official SDK for AI model deployment and inference
- **ChipOS MCP Integration** - RAG knowledge base and project management

## Data Source Selection

Each command will ask you to choose a data source:
1. **ChipOS Knowledge Base Only** - Use RAG for research and guidance only (no local execution)
2. **ChipOS Knowledge Base + Local SDK** - Use RAG for guidance, execute on local SDK
3. **Local Voyager SDK Repository** - Use an existing local installation
4. **Clone Fresh Repository** - Clone latest Voyager SDK from GitHub

## ChipOS MCP Integration

These commands work with the ChipOS MCP server, which provides:
- **RAG Knowledge Base**: Query indexed Voyager SDK documentation and code
- **Code Examples**: Search for implementation examples
- **Project Management**: Create and manage projects with task tracking
- **Task Management**: Track work progress with status updates (todo → doing → review → done)
- **Session Management**: Track your development sessions

### Project & Task Tracking

All commands support optional ChipOS project and task integration:
- **Create projects** to organize related work
- **Create tasks** for each piece of work
- **Update task status** as work progresses
- **Mark tasks complete** when done

Run `/init-chipos` to set up project context for your session.

### Using the RAG Tools

**Search documentation:**
```python
mcp__chipos__rag_search_knowledge_base(
    query="your question here",
    source_id="github.com/axelera-ai-hub/voyager-sdk",
    match_count=5
)
```

**Search code examples:**
```python
mcp__chipos__rag_search_code_examples(
    query="InferenceStream API",
    source_id="github.com/axelera-ai-hub/voyager-sdk",
    match_count=3
)
```

**Available sources:**
- `github.com/axelera-ai-hub/voyager-sdk` - Voyager SDK documentation and code
- `243259df980d4bea` - Axelera AI website content

## Available Commands

### Setup & Configuration

| Command | Description |
|---------|-------------|
| `/init-chipos` | Initialize ChipOS integration for task management and project tracking |

### Help & Documentation

| Command | Description |
|---------|-------------|
| `/voyager-help` | Get help using ChipOS RAG knowledge base |

### Pipeline & Model Commands

| Command | Description |
|---------|-------------|
| `/new-pipeline` | Create a complete YAML pipeline configuration |
| `/add-model` | Add a custom model to the model zoo |
| `/list-models` | List and search available models |

### Deployment & Inference Commands

| Command | Description |
|---------|-------------|
| `/deploy` | Compile and deploy a model for Metis hardware |
| `/run` | Run inference with various input sources |
| `/bench` | Benchmark model performance |

### Development Commands

| Command | Description |
|---------|-------------|
| `/new-app` | Create a Python application using InferenceStream |
| `/test` | Run tests for SDK components |
| `/build` | Build native operators, trackers, and examples |
| `/debug` | Debug pipeline, model, or inference issues |

## Quick Reference

### Initialize ChipOS for Task Tracking
```
/init-chipos                    # Interactive setup
/init-chipos new FastSAM debug  # Create new project for FastSAM debugging
/init-chipos existing           # Select from existing projects
```

### Get Help with Voyager SDK
```
/voyager-help How do I create a detection pipeline?
```

### Create and Deploy a Pipeline
```
/new-pipeline detection yolov8n for traffic monitoring
/deploy yolov8n-coco
/run yolov8n-coco usb:0
```

### Add Custom Model
```
/add-model custom ONNX model for classification
```

### Create Application
```
/new-app multi-stream monitoring app with alerts
```

### Debug Issues
```
/debug deployment fails with quantization error
```

### Benchmark Performance
```
/bench yolov8n-coco with 1000 iterations
```

## Command Structure

Each command follows this pattern:
- **Title**: What the command does
- **Instructions**: Step-by-step guidance with `$ARGUMENTS` placeholder
- **Examples**: Code snippets and command examples
- **Troubleshooting**: Common issues and solutions

## Using Arguments

Pass arguments after the command:
```
/deploy yolov5s-v7-coco --mode quantize
/run yolov8n-coco media/video.mp4 --benchmark
/new-pipeline cascade detection + classification
```

## ChipOS MCP Server

The ChipOS MCP server is automatically configured when you start Claude Code from ChipOS.

To manually verify the connection:
```bash
claude mcp list
```

## Adding Custom Commands

To add new commands:
1. Create a `.md` file in `.claude/commands/`
2. Include a title (# heading) and description
3. Add `$ARGUMENTS` where user input should be inserted
4. Use `mcp__chipos__perform_rag_query` to query the knowledge base
