# List Available Models

List and search models in the Voyager SDK model zoo for Axelera Metis AI hardware

## Important Context

**This command lists AI models available for deployment on Axelera Metis AI Processing Units (APUs).**
All models in the zoo are optimized for Metis hardware using the Voyager SDK framework.

## Instructions

List models based on the specified criteria: **$ARGUMENTS**

### Step 0: Data Source & Environment Selection

**FIRST**, use the `AskUserQuestion` tool to determine the setup:

```
Question: "Which data source would you like to use for listing models?"
Options:
1. "ChipOS Knowledge Base" - Query RAG for model information and availability
2. "Local Voyager SDK Repository" - List models from an existing local installation
3. "Clone Fresh Repository" - Clone latest Voyager SDK to see current model zoo
```

**Based on selection:**

**If ChipOS Knowledge Base:**
- Search for model information:
  ```python
  mcp__chipos__rag_search_knowledge_base(
      query="model zoo available models YOLO classification",
      source_id="github.com/axelera-ai-hub/voyager-sdk",
      match_count=10
  )
  ```
- Provide information about available models from knowledge base

**If Local Repository:**
- Ask for the repository path: "What is the path to your Voyager SDK installation?"
- Set environment:
  ```bash
  export AXELERA_FRAMEWORK=/path/to/voyager-sdk
  export AXELERA_RUNTIME_DIR=$AXELERA_FRAMEWORK/runtime
  source $AXELERA_FRAMEWORK/venv/bin/activate
  ```
- List models from `$AXELERA_FRAMEWORK/ax_models/zoo/`

**If Clone Fresh:**
- Clone and install:
  ```bash
  git clone https://github.com/axelera-ai-hub/voyager-sdk.git
  cd voyager-sdk
  ./install.sh --all --media
  source venv/bin/activate
  export AXELERA_FRAMEWORK=$(pwd)
  ```

### Step 0.5: ChipOS Project Context (Optional)

**If a project context is already set, note the available models for project planning.**

This step is informational - model listing typically doesn't create tasks, but if the user is researching models for a project:
```python
# If project context exists, this info can be used for task planning
# mcp__chipos__list_tasks(filter_by="project", filter_value="[PROJECT_ID]")
```

### Step 1: List All Models
   ```bash
   # Show all available models
   ./deploy.py --help

   # Or use make
   make help
   ```

2. **Search by Task Type**
   Search models by their primary task:

   **Object Detection:**
   ```bash
   # YOLO models
   ls ax_models/zoo/yolo/

   # SSD models
   ls ax_models/zoo/tensorflow/object_detection/

   # RetinaFace (face detection)
   ls ax_models/zoo/torch/ | grep -i retinaface
   ```

   **Classification:**
   ```bash
   # TorchVision classifiers
   ls ax_models/zoo/torchvision/classification/

   # Timm models
   ls ax_models/zoo/timm/
   ```

   **Segmentation:**
   ```bash
   # Segmentation models
   ls ax_models/zoo/mmlab/mmseg/
   ```

   **Pose Estimation:**
   ```bash
   # Pose models (YOLO-based)
   ls ax_models/zoo/yolo/ | grep -i pose
   ```

   **Depth Estimation:**
   ```bash
   ls ax_models/zoo/torch/ | grep -i depth
   ```

   **LLM/Language Models:**
   ```bash
   ls ax_models/zoo/llm/
   ls ax_models/llm/
   ```

3. **Search by Framework**
   ```bash
   # PyTorch models
   find ax_models/zoo -name "*.yaml" | xargs grep -l "source: torch"

   # ONNX models
   find ax_models/zoo -name "*-onnx.yaml"

   # Timm models
   find ax_models/zoo -name "*.yaml" | xargs grep -l "source: timm"

   # Ultralytics models
   find ax_models/zoo -name "*.yaml" | xargs grep -l "source: ultralytics"

   # TorchVision models
   ls ax_models/zoo/torchvision/
   ```

4. **Search by Dataset**
   ```bash
   # COCO trained models
   find ax_models -name "*coco*.yaml"

   # ImageNet trained models
   find ax_models -name "*imagenet*.yaml"

   # Custom/other datasets
   find ax_models -name "*widerface*.yaml"
   find ax_models -name "*lfw*.yaml"
   ```

5. **Reference Pipelines**
   ```bash
   # Cascade pipelines (multi-model)
   ls ax_models/reference/cascade/

   # Parallel pipelines
   ls ax_models/reference/parallel/

   # With tracker
   ls ax_models/reference/cascade/with_tracker/

   # Image preprocessing pipelines
   ls ax_models/reference/image_preprocess/
   ```

6. **Model Information**
   Get details about a specific model:
   ```bash
   # View model YAML
   cat ax_models/zoo/yolo/yolov8n-coco.yaml

   # Get model info via make
   make NN=yolov8n-coco info
   ```

7. **List by Model Size/Speed**
   YOLO model variants (speed vs accuracy):
   ```
   | Model    | Size  | Speed | Accuracy |
   |----------|-------|-------|----------|
   | yolov8n  | nano  | fast  | lower    |
   | yolov8s  | small | fast  | good     |
   | yolov8m  | medium| med   | better   |
   | yolov8l  | large | slow  | high     |
   | yolov8x  | xlarge| slow  | highest  |
   ```

8. **Tutorial Models**
   ```bash
   # General tutorials
   ls ax_models/tutorials/general/

   # YOLO tutorials
   ls ax_models/tutorials/yolo/

   # Custom training tutorials
   ls ax_models/tutorials/torch/
   ls ax_models/tutorials/onnx/
   ```

9. **Custom Search**
   ```bash
   # Find all detection models
   find ax_models -name "*.yaml" -exec grep -l "YoloDecoder\|SsdDecoder\|RetinaFace" {} \;

   # Find models with specific input size
   find ax_models -name "*.yaml" -exec grep -l "640, 640" {} \;

   # Find models with tracker support
   find ax_models -name "*tracker*.yaml"
   ```

10. **Model Categories Summary**
    ```
    Detection:
    - yolov5n/s/m/l/x-v7-coco    YOLO v5 variants
    - yolov8n/s/m/l/x-coco       YOLO v8 variants
    - yolov10n/s/m/l/x-coco      YOLO v10 variants
    - ssd-mobilenetv1-coco       SSD MobileNet
    - retinaface-*               Face detection

    Classification:
    - resnet18/34/50/101-imagenet
    - efficientnet_b0-b4-imagenet
    - mobilenetv2/v3-imagenet
    - densenet121-imagenet

    Pose:
    - yolov8n/s/m/l-pose         YOLO pose estimation

    Segmentation:
    - yolov8n/s-seg              Instance segmentation
    - unet_fcn-cityscapes        Semantic segmentation

    Depth:
    - fastdepth-nyudepthv2       Monocular depth

    Face:
    - facenet-lfw                Face recognition
    - retinaface-*               Face detection

    LLM:
    - llama-3-*                  Llama models
    - phi3-mini-*                Phi-3 models
    ```

11. **Check Model Availability**
    ```bash
    # Verify model exists and is valid
    ./deploy.py <model-name> --help 2>/dev/null && echo "Model available" || echo "Model not found"
    ```
