# Run Inference

Execute inference on Axelera Metis AI hardware with various input sources

## Important Context

**This command runs AI inference on Axelera Metis AI Processing Units (APUs).**
All inference is executed on Metis hardware using the Voyager SDK runtime.

## Instructions

Run inference with the specified configuration: **$ARGUMENTS**

### Step 0: Data Source & Environment Selection

**FIRST**, use the `AskUserQuestion` tool to determine the setup:

```
Question: "Which Voyager SDK setup would you like to use for inference?"
Options:
1. "ChipOS Knowledge Base Only" - Use RAG for research and inference guidance only (no local execution)
2. "ChipOS Knowledge Base + Local SDK" - Use RAG for guidance, run on local SDK
3. "Local Voyager SDK Repository" - Use an existing local installation only
4. "Clone Fresh Repository" - Clone latest Voyager SDK for inference
```

**Based on selection:**

**If ChipOS Knowledge Base Only:**
- Search for inference information and documentation:
  ```python
  mcp__chipos__rag_search_knowledge_base(
      query="inference stream input sources",
      source_id="github.com/axelera-ai-hub/voyager-sdk",
      match_count=5
  )
  mcp__chipos__rag_search_code_examples(
      query="InferenceStream API usage",
      source_id="github.com/axelera-ai-hub/voyager-sdk",
      match_count=5
  )
  ```
- Provide research-based guidance and documentation
- No local SDK execution required - purely informational

**If ChipOS Knowledge Base + Local SDK:**
- Search for inference examples:
  ```python
  mcp__chipos__rag_search_knowledge_base(
      query="inference stream input sources",
      source_id="github.com/axelera-ai-hub/voyager-sdk",
      match_count=5
  )
  ```
- Ask for local SDK path for execution
- Set environment variables accordingly

**If Local Repository:**
- Ask for the repository path: "What is the path to your Voyager SDK installation?"
- Set environment:
  ```bash
  export AXELERA_FRAMEWORK=/path/to/voyager-sdk
  export AXELERA_RUNTIME_DIR=$AXELERA_FRAMEWORK/runtime
  source $AXELERA_FRAMEWORK/venv/bin/activate
  ```

**If Clone Fresh:**
- Clone and install:
  ```bash
  git clone https://github.com/axelera-ai-hub/voyager-sdk.git
  cd voyager-sdk
  ./install.sh --all --media
  source venv/bin/activate
  export AXELERA_FRAMEWORK=$(pwd)
  ```

### Step 0.5: ChipOS Project & Task Integration

**Check if project context is already set (from previous commands or `/init-chipos`).**

If NO project context exists, ask:
```
Question: "Would you like to track this inference run in ChipOS?"
Options:
1. "Yes, use existing project" - Select from available ChipOS projects
2. "Yes, create new project" - Create a new project for this work
3. "No, skip task tracking" - Proceed without ChipOS task management
```

**If using existing project:**
```python
mcp__chipos__list_projects()
# User selects project
```

**If creating new project:**
```python
mcp__chipos__create_project(
    title="Voyager SDK Inference - [Model/Source]",
    description="Inference run: $ARGUMENTS",
    github_repo="https://github.com/axelera-ai-hub/voyager-sdk"
)
```

**Create inference task:**
```python
mcp__chipos__create_task(
    project_id="[PROJECT_ID]",
    title="Run inference: [Model/source from $ARGUMENTS]",
    description="Execute inference with: $ARGUMENTS",
    assignee="AI IDE Agent",
    feature="inference",
    task_order=10
)
mcp__chipos__update_task(task_id="[TASK_ID]", status="doing")
```

### Step 1: Environment Verification
   - Ensure environment is activated:
     ```bash
     source venv/bin/activate
     ```
   - Verify hardware is detected:
     ```bash
     axdevice list
     ```

2. **Parse Arguments**
   - Model/pipeline name (required)
   - Input source (camera, video, image, dataset, RTSP)
   - Display options
   - Output options

3. **Input Source Configuration**

   **USB Camera:**
   ```bash
   ./inference.py <model> usb:0           # First USB camera
   ./inference.py <model> usb:1           # Second USB camera
   ./inference.py <model> usb:0,usb:1     # Multiple cameras
   ```

   **Video File:**
   ```bash
   ./inference.py <model> /path/to/video.mp4
   ./inference.py <model> media/traffic1_1080p.mp4
   ```

   **Image File:**
   ```bash
   ./inference.py <model> /path/to/image.jpg
   ./inference.py <model> /path/to/images/*.jpg   # Multiple images
   ```

   **RTSP Stream:**
   ```bash
   ./inference.py <model> rtsp://user:pass@ip:port/stream
   ```

   **Dataset (for accuracy evaluation):**
   ```bash
   ./inference.py <model> dataset         # Use model's default dataset
   ./inference.py <model> dataset:coco2017
   ```

4. **Display Options**
   ```bash
   # With display window (default)
   ./inference.py <model> <source>

   # Headless mode (no display)
   ./inference.py <model> <source> --no-display

   # Console output only
   ./inference.py <model> <source> --display console

   # OpenGL display (faster)
   ./inference.py <model> <source> --display gl

   # OpenCV display
   ./inference.py <model> <source> --display cv

   # Custom window size
   ./inference.py <model> <source> --window-size 1280x720
   ```

5. **Performance Monitoring**
   ```bash
   # Show performance statistics
   ./inference.py <model> <source> --show-stats

   # Save tracer data to CSV
   ./inference.py <model> <source> --save-tracers metrics.csv

   # Append to existing tracer file
   ./inference.py <model> <source> --save-tracers +metrics.csv
   ```

6. **Output Options**
   ```bash
   # Save output video
   ./inference.py <model> <source> --output video.mp4

   # Save detection results as JSON
   ./inference.py <model> <source> --output-meta results.json

   # Save frames as images
   ./inference.py <model> <source> --output-frames /path/to/frames/
   ```

7. **Multi-Stream Configuration**
   ```bash
   # Multiple input sources
   ./inference.py <model> video1.mp4,video2.mp4

   # Mix of sources
   ./inference.py <model> usb:0,video.mp4,rtsp://stream

   # With stream-specific options
   ./inference.py <model> "usb:0?fps=30,video.mp4"
   ```

8. **Model-Specific Options**
   ```bash
   # Detection confidence threshold
   ./inference.py yolov8n-coco <source> --conf-thresh 0.5

   # IOU threshold for NMS
   ./inference.py yolov8n-coco <source> --iou-thresh 0.45

   # Limit number of detections
   ./inference.py yolov8n-coco <source> --max-detections 100
   ```

9. **Accuracy Evaluation Mode**
   ```bash
   # Evaluate on validation dataset
   ./inference.py <model> dataset --no-display

   # Evaluate with specific number of samples
   ./inference.py <model> dataset --num-samples 1000

   # Save evaluation results
   ./inference.py <model> dataset --no-display --output-meta accuracy.json
   ```

10. **Benchmarking**
    ```bash
    # Run benchmark
    ./inference.py <model> <source> --benchmark

    # Benchmark with warmup
    ./inference.py <model> <source> --benchmark --warmup 100

    # Fixed number of iterations
    ./inference.py <model> <source> --benchmark --iterations 1000
    ```

11. **Troubleshooting**

    **No display available:**
    ```bash
    # Use --no-display or --display console
    ./inference.py <model> <source> --no-display
    ```

    **Camera not found:**
    ```bash
    # List available cameras
    ls /dev/video*
    # Try different index
    ./inference.py <model> usb:1
    ```

    **Video codec issues:**
    ```bash
    # Check video format
    ffprobe video.mp4
    # Re-encode if needed
    ffmpeg -i input.mp4 -c:v h264 output.mp4
    ```

    **Low FPS:**
    - Check CPU usage
    - Try reducing resolution
    - Ensure hardware acceleration is working

12. **Example Workflows**
    ```bash
    # Quick demo with USB camera
    ./inference.py yolov5s-v7-coco usb:0

    # Accuracy evaluation
    ./inference.py yolov5s-v7-coco dataset --no-display

    # Benchmark performance
    ./inference.py yolov8n-coco media/traffic1_1080p.mp4 --benchmark

    # Multi-stream monitoring
    ./inference.py yolov5m-v7-coco-tracker usb:0,usb:1,rtsp://stream

    # Save results for analysis
    ./inference.py yolov8n-coco video.mp4 --output-meta results.json --save-tracers perf.csv
    ```
