# Run Tests

Execute tests for Voyager SDK components targeting Axelera Metis AI hardware

## Important Context

**This command runs tests for the Voyager SDK framework.**
Tests validate functionality for Axelera Metis AI Processing Unit (APU) deployment and inference.

## Instructions

Run tests based on the specified scope: **$ARGUMENTS**

### Step 0: Data Source & Environment Selection

**FIRST**, use the `AskUserQuestion` tool to determine the setup:

```
Question: "Which Voyager SDK setup would you like to use for testing?"
Options:
1. "ChipOS Knowledge Base Only" - Use RAG for research and test guidance only (no local execution)
2. "ChipOS Knowledge Base + Local SDK" - Use RAG for test guidance, run on local SDK
3. "Local Voyager SDK Repository" - Use an existing local installation only
4. "Clone Fresh Repository" - Clone latest Voyager SDK for testing
```

**Based on selection:**

**If ChipOS Knowledge Base Only:**
- Search for testing information and documentation:
  ```python
  mcp__chipos__rag_search_knowledge_base(
      query="pytest tests tox testing",
      source_id="github.com/axelera-ai-hub/voyager-sdk",
      match_count=5
  )
  mcp__chipos__rag_search_code_examples(
      query="unit test coverage",
      source_id="github.com/axelera-ai-hub/voyager-sdk",
      match_count=5
  )
  ```
- Provide research-based guidance and documentation
- No local SDK execution required - purely informational

**If ChipOS Knowledge Base + Local SDK:**
- Search for test examples:
  ```python
  mcp__chipos__rag_search_knowledge_base(
      query="pytest tests tox testing",
      source_id="github.com/axelera-ai-hub/voyager-sdk",
      match_count=5
  )
  ```
- Ask for local SDK path for execution
- Set environment variables accordingly

**If Local Repository:**
- Ask for the repository path: "What is the path to your Voyager SDK installation?"
- Set environment:
  ```bash
  export AXELERA_FRAMEWORK=/path/to/voyager-sdk
  export AXELERA_RUNTIME_DIR=$AXELERA_FRAMEWORK/runtime
  source $AXELERA_FRAMEWORK/venv/bin/activate
  ```

**If Clone Fresh:**
- Clone and install:
  ```bash
  git clone https://github.com/axelera-ai-hub/voyager-sdk.git
  cd voyager-sdk
  ./install.sh --all --media
  source venv/bin/activate
  export AXELERA_FRAMEWORK=$(pwd)
  ```

### Step 0.5: ChipOS Project & Task Integration

**Check if project context is already set (from previous commands or `/init-chipos`).**

If NO project context exists, ask:
```
Question: "Would you like to track this test run in ChipOS?"
Options:
1. "Yes, use existing project" - Select from available ChipOS projects
2. "Yes, create new project" - Create a new project for this work
3. "No, skip task tracking" - Proceed without ChipOS task management
```

**If using existing project:**
```python
mcp__chipos__list_projects()
# User selects project
```

**If creating new project:**
```python
mcp__chipos__create_project(
    title="Voyager SDK Testing - [Test Scope]",
    description="Test execution: $ARGUMENTS",
    github_repo="https://github.com/axelera-ai-hub/voyager-sdk"
)
```

**Create testing task:**
```python
mcp__chipos__create_task(
    project_id="[PROJECT_ID]",
    title="Run tests: [Test scope from $ARGUMENTS]",
    description="Execute tests: $ARGUMENTS",
    assignee="AI IDE Agent",
    feature="testing",
    task_order=10
)
mcp__chipos__update_task(task_id="[TASK_ID]", status="doing")
```

### Step 1: Environment Setup
   - Ensure virtual environment is activated:
     ```bash
     source venv/bin/activate
     ```
   - Install test dependencies if needed:
     ```bash
     pip install -r requirements.unittests.txt
     ```

2. **Test Scope Identification**
   Parse test scope from arguments:
   - `all`: Run all tests
   - `unit`: Run unit tests only
   - `runtime`: Run runtime-specific tests
   - `<module>`: Run tests for specific module
   - `<file>`: Run specific test file
   - `<pattern>`: Run tests matching pattern

3. **Running All Tests with Tox**
   ```bash
   # Run all default test environments
   tox

   # Run specific Python version
   tox -e py310
   tox -e py312

   # Run runtime tests
   tox -e py310-runtime

   # Run with verbose output
   tox -v
   ```

4. **Running Tests with Pytest**
   ```bash
   # Run all tests
   pytest tests/

   # Run specific test file
   pytest tests/test_axelera_config.py

   # Run specific test function
   pytest tests/test_axelera_config.py::test_function_name

   # Run tests matching pattern
   pytest tests/ -k "config"
   pytest tests/ -k "network and not slow"

   # Run with verbose output
   pytest tests/ -v

   # Run with very verbose output (show locals)
   pytest tests/ -vv
   ```

5. **Coverage Reports**
   ```bash
   # Run with coverage
   pytest tests/ --cov=. --cov-report=html --cov-report=term

   # View HTML coverage report
   open htmlcov/index.html

   # Coverage for specific module
   pytest tests/ --cov=axelera/app --cov-report=term-missing
   ```

6. **Test Categories**

   **Core SDK Tests:**
   ```bash
   pytest tests/test_axelera_config.py      # Configuration
   pytest tests/test_axelera_network.py     # Network handling
   pytest tests/test_axelera_pipeline.py    # Pipeline operations
   pytest tests/test_axelera_compile.py     # Compilation
   ```

   **Display/UI Tests:**
   ```bash
   pytest tests/test_axelera_display.py
   pytest tests/test_axelera_display_cv.py
   pytest tests/test_axelera_display_console.py
   ```

   **Operator Tests:**
   ```bash
   pytest tests/test_ax_operator.py
   pytest tests/test_axelera_operators_inference.py
   ```

   **Model Tests:**
   ```bash
   pytest tests/test_ax_models_base_torch.py
   pytest tests/test_ax_models_decoders_yolo.py
   pytest tests/test_ax_models_decoders_ssd.py
   ```

   **Metadata Tests:**
   ```bash
   pytest tests/test_ax_meta.py
   pytest tests/test_axelera_meta_base.py
   pytest tests/test_axelera_meta_gst.py
   ```

7. **Code Quality Checks**
   ```bash
   # Format check (isort + black)
   tox -e fmt-check

   # Auto-format code
   tox -e fmt

   # Lint with flake8
   tox -e lint

   # Type checking (if enabled)
   tox -e type-check
   ```

8. **Running Specific Test Patterns**
   ```bash
   # Tests for a specific feature
   pytest tests/ -k "yaml"
   pytest tests/ -k "decoder"
   pytest tests/ -k "stream"

   # Exclude slow tests
   pytest tests/ -k "not slow"

   # Only failed tests from last run
   pytest tests/ --lf

   # First failed test only
   pytest tests/ --ff
   ```

9. **Debugging Failed Tests**
   ```bash
   # Stop on first failure
   pytest tests/ -x

   # Enter debugger on failure
   pytest tests/ --pdb

   # Show local variables in tracebacks
   pytest tests/ -l

   # Capture stdout/stderr
   pytest tests/ -s
   ```

10. **Parallel Test Execution**
    ```bash
    # Run tests in parallel (requires pytest-xdist)
    pytest tests/ -n auto
    pytest tests/ -n 4  # Use 4 workers
    ```

11. **Test Output and Reporting**
    ```bash
    # JUnit XML report (for CI)
    pytest tests/ --junitxml=results.xml

    # HTML report
    pytest tests/ --html=report.html

    # Detailed test durations
    pytest tests/ --durations=10
    ```

12. **Common Test Issues**

    **Import errors:**
    ```bash
    # Ensure PYTHONPATH is set
    export PYTHONPATH=$AXELERA_FRAMEWORK:$PYTHONPATH
    ```

    **Missing dependencies:**
    ```bash
    pip install -r requirements.unittests.txt
    ```

    **Runtime-specific tests failing:**
    ```bash
    # Install runtime packages
    pip install -r requirements.runtime.txt
    ```

    **Test isolation issues:**
    ```bash
    # Run tests in random order
    pytest tests/ --random-order
    ```

13. **Writing New Tests**
    When adding new tests:
    - Place in `tests/` directory
    - Follow naming: `test_<module>.py`
    - Use descriptive test function names: `test_<feature>_<scenario>`
    - Add appropriate markers for slow/integration tests
    - Include both positive and negative test cases
