# Voyager SDK Help

Get help with Voyager SDK for Axelera Metis AI hardware

## Important Context

**This command is specifically for Axelera AI's Voyager SDK and Metis hardware.**
All solutions should target the Axelera Metis AI Processing Unit (APU) and use the Voyager SDK framework.

## Instructions

Answer questions about Voyager SDK: **$ARGUMENTS**

### Step 1: Data Source Selection

**FIRST**, use the `AskUserQuestion` tool to determine which data source to use:

```
Question: "Which data source would you like to use for Voyager SDK information?"
Options:
1. "ChipOS Knowledge Base Only" - Use RAG to query indexed Voyager SDK documentation (no local execution)
2. "ChipOS Knowledge Base + Local SDK" - Use RAG for guidance, reference local SDK for details
3. "Local Voyager SDK Repository" - Use an existing local installation only
4. "Clone Fresh Repository" - Clone the latest Voyager SDK from GitHub
```

### Step 2: Configure Based on Selection

**If ChipOS Knowledge Base selected:**
- Use `mcp__chipos__rag_search_knowledge_base` with `source_id: "github.com/axelera-ai-hub/voyager-sdk"`
- Use `mcp__chipos__rag_search_code_examples` for code samples
- Query the Axelera website source (`source_id: "243259df980d4bea"`) for product info

Example RAG queries:
```python
# Search documentation
mcp__chipos__rag_search_knowledge_base(
    query="detection pipeline YOLOv8",
    source_id="github.com/axelera-ai-hub/voyager-sdk",
    match_count=5
)

# Search code examples
mcp__chipos__rag_search_code_examples(
    query="InferenceStream API",
    source_id="github.com/axelera-ai-hub/voyager-sdk",
    match_count=3
)
```

**If Local Repository selected:**
- Ask for the repository path using `AskUserQuestion`
- Set environment variables:
  ```bash
  export AXELERA_FRAMEWORK=/path/to/voyager-sdk
  export AXELERA_RUNTIME_DIR=$AXELERA_FRAMEWORK/runtime
  source $AXELERA_FRAMEWORK/venv/bin/activate
  ```
- Read files directly from the local repository

**If Clone Fresh selected:**
- Clone the repository:
  ```bash
  git clone https://github.com/axelera-ai-hub/voyager-sdk.git
  cd voyager-sdk
  ./install.sh --all --media
  source venv/bin/activate
  ```
- Set AXELERA_FRAMEWORK to the cloned directory

### Step 3: Answer the Question

After gathering information from the selected source:

1. **Synthesize Response**
   - Always frame answers in context of Axelera Metis hardware
   - Provide Voyager SDK-specific code examples
   - Reference specific SDK components (InferenceStream, deploy.py, inference.py)

2. **Include Practical Examples**
   - Show actual command-line usage
   - Include YAML pipeline snippets when relevant
   - Reference model zoo locations (`ax_models/zoo/`)

3. **Hardware Context**
   - Mention Metis M.2 or PCIe target when relevant
   - Include AIPU core configuration options
   - Reference hardware capabilities (vaapi, opencl, opengl)

### Common Topics

| Topic | RAG Query | Key Files |
|-------|-----------|-----------|
| Pipeline YAML | "pipeline YAML structure" | `ax_models/zoo/**/*.yaml` |
| InferenceStream | "InferenceStream API" | `axelera/app/stream.py` |
| Deployment | "model deployment compile" | `deploy.py`, `axelera/app/compile.py` |
| Input Sources | "USB RTSP video sources" | `axelera/app/config.py` |
| Custom Operators | "custom operator pipeline" | `axelera/app/operators/` |
| Trackers | "ByteTrack OC-SORT" | `trackers/` |

### Example Usage

```
/voyager-help How do I set up multi-stream inference?
/voyager-help What models are available for object detection?
/voyager-help How to create a custom post-processor?
/voyager-help Explain the pipeline YAML structure
/voyager-help How to optimize for Metis PCIe with 4 cores?
```
